/*
 * NOTE: Before start to code or compile with this example, please install 
 * java CAEN RFID API in your local maven repository. Library and doc are in 
 * the root folder of this project.
 */
package com.caenrfid.openjdk;

import com.caen.RFIDLibrary.*;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Hex;

/**
 *
 * @author caenrfid
 */
public class OpenJDK {

    static int tagCounter = 0;

    public static void main(String[] args) throws CAENRFIDException, InterruptedException {
        // 1) Create a CAENRFIDReader instance and connect to the reader.
        CAENRFIDReader reader = new CAENRFIDReader();
        System.out.println("Start");
        reader.Connect(CAENRFIDPort.CAENRFID_TCP, "10.106.254.115");
        // 2) Set the conducted power to 50 mW.
        reader.SetPower(50);
        // 3) Gets CAEN RFID reader information
        CAENRFIDReaderInfo info = reader.GetReaderInfo();
        System.out.println("Reader info -> Model is: " + info.GetModel() + " and "
                + "serial number is: " + info.GetSerialNumber());
        // 4) Configure continuous inventory with the user-defined callback.
        reader.addCAENRFIDEventListener((CAENRFIDEvent evt) -> {
            tagCounter++;
            System.out.println("Tag n: " + tagCounter);
            ArrayList<CAENRFIDNotify> notifies = evt.getData();
            for (CAENRFIDNotify notify : notifies) {
                System.out.println("    Tag -> " + Hex.encodeHexString(notify.getTagID()));
            }
        });
        // 5) Gets the current readcycle and set readcycle to 0 (infinity cycles)
        int rc = reader.GetSource("Source_0").GetReadCycle();
        reader.GetSource("Source_0").SetReadCycle(0);
        // 6) Sets the mandatory flags for continuous inventory API call. 
        short flags = (short)(CAENRFIDLogicalSource.InventoryFlag.CONTINUOS
                .getValue() + CAENRFIDLogicalSource.InventoryFlag.FRAMED
                        .getValue());
        // 7) launching continuous inventory with no filters on EPC bank.
        reader.GetSource("Source_0").EventInventoryTag(new byte[12], 
                (short) 0, (short) 0, flags);
        // 8) Wait to see some tag printing on console.
        Thread.sleep(5000);
        // 9 ) Stop continuous inventory.
        reader.InventoryAbort();
        // 10) Restore readcyle and disconnect. 
        reader.GetSource("Source_0").SetReadCycle(rc);
        reader.Disconnect();
        System.out.println("End");
    }
}
